/*
 * Decompiled with CFR 0.152.
 */
package lotr.common.item;

import cpw.mods.fml.relauncher.Side;
import cpw.mods.fml.relauncher.SideOnly;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Random;
import lotr.common.LOTRCreativeTabs;
import lotr.common.LOTRMod;
import lotr.common.enchant.LOTREnchantment;
import lotr.common.enchant.LOTREnchantmentHelper;
import lotr.common.enchant.LOTREnchantmentType;
import net.minecraft.client.renderer.texture.IIconRegister;
import net.minecraft.creativetab.CreativeTabs;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.NBTBase;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.nbt.NBTTagString;
import net.minecraft.util.IIcon;
import net.minecraft.util.WeightedRandom;

public class LOTRItemModifierTemplate
extends Item {
    private static final List<List<LOTREnchantmentType>> TYPE_LIST = Arrays.asList(Arrays.asList(LOTREnchantmentType.ARMOR, LOTREnchantmentType.ARMOR_BODY, LOTREnchantmentType.ARMOR_FEET, LOTREnchantmentType.ARMOR_HEAD, LOTREnchantmentType.ARMOR_LEGS), Collections.singletonList(LOTREnchantmentType.MELEE), Arrays.asList(LOTREnchantmentType.RANGED, LOTREnchantmentType.RANGED_LAUNCHER), Collections.singletonList(LOTREnchantmentType.TOOL));
    private static final Map<LOTREnchantment, Integer> ENCHANTMENT_MAP = new HashMap<LOTREnchantment, Integer>();
    private final IIcon[] icons = new IIcon[TYPE_LIST.size() + 1];

    public LOTRItemModifierTemplate() {
        this.func_77625_d(1);
        this.func_77637_a(LOTRCreativeTabs.tabMaterials);
    }

    public static LOTREnchantment getModifier(ItemStack itemstack) {
        NBTTagCompound nbt = itemstack.func_77978_p();
        if (nbt != null) {
            String enchantmentName = nbt.func_74779_i("ScrollModifier");
            return LOTREnchantment.getEnchantmentByName(enchantmentName);
        }
        return null;
    }

    public static void setModifier(ItemStack itemstack, LOTREnchantment enchantment) {
        if (enchantment != null) {
            itemstack.func_77983_a("ScrollModifier", (NBTBase)new NBTTagString(enchantment.enchantName));
        }
    }

    public static ItemStack getRandomCommonTemplate(Random random) {
        ArrayList<LOTREnchantmentHelper.WeightedRandomEnchant> applicable = new ArrayList<LOTREnchantmentHelper.WeightedRandomEnchant>();
        for (LOTREnchantment enchantment : LOTREnchantment.allEnchantments) {
            if (!enchantment.hasTemplateItem()) continue;
            int weight = LOTREnchantmentHelper.getSkilfulWeight(enchantment);
            LOTREnchantmentHelper.WeightedRandomEnchant wre = new LOTREnchantmentHelper.WeightedRandomEnchant(enchantment, weight);
            applicable.add(wre);
        }
        LOTREnchantmentHelper.WeightedRandomEnchant chosenWre = (LOTREnchantmentHelper.WeightedRandomEnchant)WeightedRandom.func_76271_a((Random)random, applicable);
        LOTREnchantment chosenEnch = chosenWre.theEnchant;
        ItemStack itemstack = new ItemStack(LOTRMod.modTemplate);
        LOTRItemModifierTemplate.setModifier(itemstack, chosenEnch);
        return itemstack;
    }

    public String func_77653_i(ItemStack itemstack) {
        String baseName = super.func_77653_i(itemstack);
        LOTREnchantment enchantment = LOTRItemModifierTemplate.getModifier(itemstack);
        if (enchantment != null) {
            return String.format(baseName, enchantment.getDisplayName());
        }
        return baseName;
    }

    @SideOnly(value=Side.CLIENT)
    public void func_77624_a(ItemStack itemstack, EntityPlayer player, List tooltip, boolean advanced) {
        super.func_77624_a(itemstack, player, tooltip, advanced);
        LOTREnchantment enchantment = LOTRItemModifierTemplate.getModifier(itemstack);
        if (enchantment != null) {
            tooltip.add(enchantment.getNamedFormattedDescription(itemstack));
        }
    }

    @SideOnly(value=Side.CLIENT)
    public void func_150895_a(Item item, CreativeTabs tab, List subItems) {
        for (LOTREnchantment enchantment : LOTREnchantment.allEnchantments) {
            if (!enchantment.hasTemplateItem()) continue;
            ItemStack itemstack = new ItemStack((Item)this);
            LOTRItemModifierTemplate.setModifier(itemstack, enchantment);
            subItems.add(itemstack);
        }
    }

    @SideOnly(value=Side.CLIENT)
    public IIcon getIcon(ItemStack itemstack, int pass) {
        return this.func_77650_f(itemstack);
    }

    @SideOnly(value=Side.CLIENT)
    public IIcon func_77650_f(ItemStack itemstack) {
        LOTREnchantment enchantment = LOTRItemModifierTemplate.getModifier(itemstack);
        int index = ENCHANTMENT_MAP.getOrDefault(enchantment, 0);
        return this.icons[index];
    }

    @SideOnly(value=Side.CLIENT)
    public void func_94581_a(IIconRegister iconRegister) {
        this.icons[0] = iconRegister.func_94245_a(this.func_111208_A());
        for (int i = 1; i <= TYPE_LIST.size(); ++i) {
            this.icons[i] = iconRegister.func_94245_a(this.func_111208_A() + "_" + i);
        }
    }

    static {
        for (LOTREnchantment enchantment : LOTREnchantment.allEnchantments) {
            int iconIndex = 0;
            for (int i = 0; i < TYPE_LIST.size(); ++i) {
                for (LOTREnchantmentType type : TYPE_LIST.get(i)) {
                    if (!enchantment.itemTypes.contains((Object)type)) continue;
                    iconIndex = i + 1;
                    break;
                }
                if (iconIndex > 0) break;
            }
            ENCHANTMENT_MAP.put(enchantment, iconIndex);
        }
    }
}

